
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name="bananas", lb=0)
x2 = m.addVar(name="milkshakes", lb=0)

# Set the objective function
m.setObjective(9.92*x1*x2 + 7.8*x2**2 + 3.23*x1 + 6.31*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 6*x2 <= 47, name="fat_constraint")
m.addConstr(x1**2 + x2**2 >= 15, name="min_fat_squared")
m.addConstr(7*x1**2 - 8*x2**2 >= 0, name="squared_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bananas: {x1.x}")
    print(f"Milkshakes: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
