
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
bananas = model.addVar(lb=0, name="bananas", vtype=gurobi.GRB.CONTINUOUS)
milkshakes = model.addVar(lb=0, name="milkshakes", vtype=gurobi.GRB.CONTINUOUS)

# Objective function
model.setObjective(9.92 * bananas * milkshakes + 7.8 * milkshakes**2 + 3.23 * bananas + 6.31 * milkshakes, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(bananas + 6 * milkshakes <= 47, name="fat_constraint")
model.addConstr(bananas**2 + milkshakes**2 >= 15, name="min_fat_squares_constraint")
model.addConstr(7 * bananas**2 - 8 * milkshakes**2 >= 0, name="relationship_constraint")
model.addConstr(bananas + milkshakes <= 36, name="sum_constraint")

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bananas: {bananas.varValue}")
    print(f"Milkshakes: {milkshakes.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
