
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, name=["George", "Paul", "Peggy", "Jean", "Bill"])


# Set objective function
m.setObjective(8*x[0] + 6*x[1] + 1*x[2] + 9*x[3] + 9*x[4], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x[0] + 1*x[3] >= 5)
m.addConstr(3*x[0] + 2*x[2] + 1*x[3] >= 8)
m.addConstr(3*x[0] + 3*x[1] + 2*x[2] >= 8)
m.addConstr(3*x[0] + 3*x[1] + 1*x[3] >= 8)
m.addConstr(3*x[0] + 1*x[3] + 5*x[4] >= 8)
m.addConstr(3*x[1] + 2*x[2] + 5*x[4] >= 8)
m.addConstr(2*x[2] + 1*x[3] + 5*x[4] >= 8)
m.addConstr(3*x[0] + 2*x[2] + 1*x[3] >= 10)
m.addConstr(3*x[0] + 3*x[1] + 2*x[2] >= 10)
m.addConstr(3*x[0] + 3*x[1] + 1*x[3] >= 10)
m.addConstr(3*x[0] + 1*x[3] + 5*x[4] >= 10)
m.addConstr(3*x[1] + 2*x[2] + 5*x[4] >= 10)
m.addConstr(2*x[2] + 1*x[3] + 5*x[4] >= 10)
m.addConstr(3*x[0] + 2*x[2] + 1*x[3] >= 12)
m.addConstr(3*x[0] + 3*x[1] + 2*x[2] >= 12)
m.addConstr(3*x[0] + 3*x[1] + 1*x[3] >= 12)
m.addConstr(3*x[0] + 1*x[3] + 5*x[4] >= 12)
m.addConstr(3*x[1] + 2*x[2] + 5*x[4] >= 12)
m.addConstr(2*x[2] + 1*x[3] + 5*x[4] >= 12)
m.addConstr(3*x[0] + 2*x[2] + 1*x[3] >= 15)
m.addConstr(3*x[0] + 3*x[1] + 2*x[2] >= 15)
m.addConstr(3*x[0] + 3*x[1] + 1*x[3] >= 15)
m.addConstr(3*x[0] + 1*x[3] + 5*x[4] >= 15)
m.addConstr(3*x[1] + 2*x[2] + 5*x[4] >= 15)
m.addConstr(2*x[2] + 1*x[3] + 5*x[4] >= 15)
m.addConstr(3*x[0] + 2*x[4] >= 4)
m.addConstr(3*x[0] + 3*x[2] >= 7)
m.addConstr(3*x[1] + 5*x[4] <= 48)
m.addConstr(1*x[3] + 5*x[4] <= 54)
m.addConstr(3*x[0] + 1*x[3] <= 50)
m.addConstr(2*x[2] + 1*x[3] <= 19)
m.addConstr(3*x[0] + 2*x[2] <= 61)
m.addConstr(3*x[1] + 1*x[3] <= 29)
m.addConstr(3*x[0] + 1*x[3] + 5*x[4] <= 75)
m.addConstr(3*x[1] + 2*x[2] + 1*x[3] <= 59)
m.addConstr(3*x[0] + 3*x[1] + 2*x[2] + 1*x[3] + 5*x[4] <= 59)
m.addConstr(5*x[2] + 4*x[3] <= 32)
m.addConstr(4*x[3] + 2*x[4] <= 53)
m.addConstr(1*x[0] + 5*x[2] <= 65)
m.addConstr(4*x[1] + 2*x[4] <= 49)
m.addConstr(4*x[1] + 5*x[2] <= 77)
m.addConstr(4*x[1] + 5*x[2] + 4*x[3] <= 61)
m.addConstr(5*x[2] + 4*x[3] + 2*x[4] <= 29)
m.addConstr(4*x[1] + 4*x[3] + 2*x[4] <= 55)
m.addConstr(1*x[0] + 4*x[1] + 5*x[2] + 4*x[3] + 2*x[4] <= 55)
m.addConstr(3*x[0] + 3*x[2] <= 64)
m.addConstr(2*x[1] + 2*x[4] <= 61)
m.addConstr(3*x[0] + 2*x[4] <= 45)
m.addConstr(3*x[0] + 2*x[1] <= 64)
m.addConstr(5*x[3] + 2*x[4] <= 35)
m.addConstr(3*x[2] + 5*x[3] <= 28)
m.addConstr(2*x[1] + 3*x[2] <= 57)
m.addConstr(3*x[2] + 2*x[4] <= 58)
m.addConstr(3*x[0] + 2*x[1] + 3*x[2] + 5*x[3] + 2*x[4] <= 58)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

