
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by George
x1 = m.addVar(name="x1", lb=0)  # hours worked by Paul
x2 = m.addVar(name="x2", lb=0)  # hours worked by Peggy
x3 = m.addVar(name="x3", lb=0)  # hours worked by Jean
x4 = m.addVar(name="x4", lb=0)  # hours worked by Bill

# Define the objective function
m.setObjective(8*x0 + 6*x1 + x2 + 9*x3 + 9*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0 >= 3)
m.addConstr(x0 >= 1)
m.addConstr(3*x0 >= 3)
m.addConstr(3*x1 >= 3)
m.addConstr(4*x1 >= 4)
m.addConstr(2*x1 >= 2)
m.addConstr(2*x2 >= 2)
m.addConstr(5*x2 >= 5)
m.addConstr(3*x2 >= 3)
m.addConstr(x3 >= 1)
m.addConstr(4*x3 >= 4)
m.addConstr(5*x3 >= 5)
m.addConstr(5*x4 >= 5)
m.addConstr(2*x4 >= 2)
m.addConstr(2*x4 >= 2)
m.addConstr(3*x0 + x3 >= 5)
m.addConstr(3*x0 + 2*x2 + x3 >= 8)
m.addConstr(3*x0 + 3*x1 + 2*x2 >= 8)
m.addConstr(3*x0 + 3*x1 + x3 >= 8)
m.addConstr(3*x0 + x3 + 5*x4 >= 8)
m.addConstr(3*x1 + 2*x2 + 5*x4 >= 8)
m.addConstr(2*x2 + x3 + 5*x4 >= 8)
m.addConstr(3*x0 + 2*x2 + x3 >= 10)
m.addConstr(3*x0 + 3*x1 + 2*x2 >= 10)
m.addConstr(3*x0 + 3*x1 + x3 >= 10)
m.addConstr(3*x0 + x3 + 5*x4 >= 10)
m.addConstr(3*x1 + 2*x2 + 5*x4 >= 10)
m.addConstr(2*x2 + x3 + 5*x4 >= 10)
m.addConstr(3*x0 + 2*x2 + x3 >= 12)
m.addConstr(3*x0 + 3*x1 + 2*x2 >= 12)
m.addConstr(3*x0 + 3*x1 + x3 >= 12)
m.addConstr(3*x0 + x3 + 5*x4 >= 12)
m.addConstr(3*x1 + 2*x2 + 5*x4 >= 12)
m.addConstr(2*x2 + x3 + 5*x4 >= 12)
m.addConstr(3*x0 + 2*x2 + x3 >= 15)
m.addConstr(3*x0 + 3*x1 + 2*x2 >= 15)
m.addConstr(3*x0 + 3*x1 + x3 >= 15)
m.addConstr(3*x0 + x3 + 5*x4 >= 15)
m.addConstr(3*x1 + 2*x2 + 5*x4 >= 15)
m.addConstr(2*x2 + x3 + 5*x4 >= 15)

m.addConstr(3*x0 + 3*x1 + x2 <= 77)
m.addConstr(3*x1 + 5*x2 <= 78)
m.addConstr(3*x0 + 5*x4 <= 64)
m.addConstr(3*x1 + 2*x4 <= 64)
m.addConstr(3*x0 + 2*x2 <= 64)
m.addConstr(x3 + 2*x4 <= 35)
m.addConstr(3*x2 + 5*x3 <= 28)
m.addConstr(2*x1 + 3*x2 <= 57)
m.addConstr(3*x2 + 2*x4 <= 58)
m.addConstr(3*x0 + 6*x1 + 3*x2 + 5*x3 + 2*x4 <= 58)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("No optimal solution found")
