
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
sashimi = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sashimi")
bagged_salads = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
hamburgers = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hamburgers")
black_beans = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="black_beans")


# Set objective function
model.setObjective(5.74 * sashimi + 6.64 * bagged_salads + 4.51 * hamburgers + 4.14 * black_beans, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * bagged_salads + 3 * hamburgers + 10 * black_beans >= 17, "c1")
model.addConstr(4 * bagged_salads + 10 * black_beans <= 38, "c2")
model.addConstr(5 * sashimi + 10 * black_beans <= 37, "c3")
model.addConstr(3 * hamburgers + 10 * black_beans <= 62, "c4")
model.addConstr(5 * sashimi + 4 * bagged_salads <= 74, "c5")
model.addConstr(5 * sashimi + 4 * bagged_salads + 10 * black_beans <= 71, "c6")
model.addConstr(5 * sashimi + 4 * bagged_salads + 3 * hamburgers + 10 * black_beans <= 71, "c7")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print("Variable values:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

