
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    sashimi = model.addVar(name="sashimi", lb=0)
    bagged_salads = model.addVar(name="bagged_salads", lb=0)
    hamburgers = model.addVar(name="hamburgers", lb=0)
    black_beans = model.addVar(name="black beans", lb=0, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(5.74 * sashimi + 6.64 * bagged_salads + 4.51 * hamburgers + 4.14 * black_beans, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * bagged_salads + 3 * hamburgers + 10 * black_beans >= 17)
    model.addConstr(4 * bagged_salads + 10 * black_beans <= 38)
    model.addConstr(5 * sashimi + 10 * black_beans <= 37)
    model.addConstr(3 * hamburgers + 10 * black_beans <= 62)
    model.addConstr(5 * sashimi + 4 * bagged_salads <= 74)
    model.addConstr(5 * sashimi + 4 * bagged_salads + 10 * black_beans <= 71)
    model.addConstr(5 * sashimi + 4 * bagged_salads + 3 * hamburgers + 10 * black_beans <= 71)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Sashimi: {sashimi.x}")
        print(f"Bagged Salads: {bagged_salads.x}")
        print(f"Hamburgers: {hamburgers.x}")
        print(f"Black Beans: {black_beans.x}")
        print(f"Objective: {model.objval}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
