
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    mary_hours = model.addVar(vtype=gp.GRB.INTEGER, name="mary_hours")
    paul_hours = model.addVar(vtype=gp.GRB.INTEGER, name="paul_hours")


    # Set objective function
    model.setObjective(4.13 * mary_hours + 9.68 * paul_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6.58 * mary_hours + 2.37 * paul_hours >= 14, "likelihood_to_quit_min")
    model.addConstr(6.32 * mary_hours + 2.73 * paul_hours >= 31, "computer_competence_min")
    model.addConstr(-9 * mary_hours + paul_hours >= 0, "constraint_3")
    model.addConstr(6.58 * mary_hours + 2.37 * paul_hours <= 28, "likelihood_to_quit_max")
    model.addConstr(6.32 * mary_hours + 2.73 * paul_hours <= 46, "computer_competence_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Mary: {mary_hours.x}")
        print(f"Hours worked by Paul: {paul_hours.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

