
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Mary")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Paul")

# Set the objective function
m.setObjective(4.13*x1 + 9.68*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6.58*x1 + 2.37*x2 >= 14, "likelihood_to_quit_index_min")
m.addConstr(6.32*x1 + 2.73*x2 >= 31, "computer_competence_rating_min")
m.addConstr(-9*x1 + x2 >= 0, "constraint_3")
m.addConstr(6.58*x1 + 2.37*x2 <= 28, "likelihood_to_quit_index_max")
m.addConstr(6.32*x1 + 2.73*x2 <= 46, "computer_competence_rating_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Mary: {x1.x}")
    print(f"Hours worked by Paul: {x2.x}")
else:
    print("No optimal solution found")
