
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Mary", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_Paul", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(4.13 * x1 + 9.68 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(6.58 * x1 + 2.37 * x2 >= 14, name="likelihood_to_quit_index_constraint")
m.addConstr(6.32 * x1 + 2.73 * x2 >= 31, name="computer_competence_rating_constraint")
m.addConstr(-9 * x1 + x2 >= 0, name="hours_worked_constraint")
m.addConstr(6.58 * x1 + 2.37 * x2 <= 28, name="likelihood_to_quit_index_upper_bound_constraint")
m.addConstr(6.32 * x1 + 2.73 * x2 <= 46, name="computer_competence_rating_upper_bound_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Mary: {x1.varValue}")
    print(f"Hours worked by Paul: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
