
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="CBRN_platoons")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="water_purification_units")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="light_infantry_companies")


    # Set objective function
    m.setObjective(5.01 * x0 + 7.22 * x1 + 3.34 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1.53 * x0 + 8.14 * x2 >= 26, "c1")
    m.addConstr(5.73 * x1 + 8.14 * x2 >= 24, "c2")
    m.addConstr(1.53 * x0 + 5.73 * x1 + 8.14 * x2 >= 24, "c3")
    m.addConstr(-1* x0 + 6 * x1 >= 0, "c4")
    m.addConstr(1.53 * x0 + 5.73 * x1 <= 59, "c5")
    m.addConstr(1.53 * x0 + 5.73 * x1 + 8.14 * x2 <= 47, "c6")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('CBRN platoons:', x0.x)
        print('Water purification units:', x1.x)
        print('Light infantry companies:', x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
