
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='CBRN_platoons', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='water_purification_units', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='light_infantry_companies', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(5.01 * x1 + 7.22 * x2 + 3.34 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1.53 * x1 + 8.14 * x3 >= 26)
    model.addConstr(5.73 * x2 + 8.14 * x3 >= 24)
    model.addConstr(1.53 * x1 + 5.73 * x2 + 8.14 * x3 >= 24)
    model.addConstr(-x1 + 6 * x2 >= 0)
    model.addConstr(1.53 * x1 + 5.73 * x2 <= 59)
    model.addConstr(1.53 * x1 + 5.73 * x2 + 8.14 * x3 <= 47)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('CBRN platoons: ', x1.varValue)
        print('Water purification units: ', x2.varValue)
        print('Light infantry companies: ', x3.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
