
import gurobipy as gp

# Create a new model
m = gp.Model("plant_optimization")

# Create variables
ferns = m.addVar(vtype=gp.GRB.INTEGER, name="ferns")
potato_vines = m.addVar(vtype=gp.GRB.INTEGER, name="potato_vines")

# Set objective function
m.setObjective(9 * ferns + 7 * potato_vines, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * ferns + 9 * potato_vines >= 6, "water_need_min")
m.addConstr(1 * ferns + 1 * potato_vines >= 33, "resilience_min")
m.addConstr(1 * ferns + 3 * potato_vines >= 17, "beauty_min")
m.addConstr(2 * ferns + 2 * potato_vines >= 20, "cost_min")
m.addConstr(1 * ferns - 7 * potato_vines >= 0, "ferns_potato_ratio")
m.addConstr(2 * ferns + 9 * potato_vines <= 24, "water_need_max")
m.addConstr(1 * ferns + 1 * potato_vines <= 90, "resilience_max")
m.addConstr(1 * ferns + 3 * potato_vines <= 32, "beauty_max")
m.addConstr(2 * ferns + 2 * potato_vines <= 47, "cost_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('ferns:', ferns.x)
    print('potato_vines:', potato_vines.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

