
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Define variables
x1 = model.addVar(vtype=GRB.INTEGER, name="ferns")
x2 = model.addVar(vtype=GRB.INTEGER, name="potato_vines")

# Set the objective function
model.setObjective(9*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints
model.addConstr(2*x1 + 9*x2 >= 6, "water_need_min")
model.addConstr(1*x1 + 1*x2 >= 33, "resilience_index_min")
model.addConstr(1*x1 + 3*x2 >= 17, "beauty_rating_min")
model.addConstr(2*x1 + 2*x2 >= 20, "min_spend")
model.addConstr(1*x1 - 7*x2 >= 0, "fern_vine_constraint")
model.addConstr(2*x1 + 9*x2 <= 24, "water_need_max")
model.addConstr(1*x1 + 1*x2 <= 90, "resilience_index_max")
model.addConstr(1*x1 + 3*x2 <= 32, "beauty_rating_max")
model.addConstr(2*x1 + 2*x2 <= 47, "max_spend")

# Optimize the model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Ferns: {x1.x}")
    print(f"Potato Vines: {x2.x}")
else:
    print("No optimal solution found")
