
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="ferns", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="potato_vines", vtype=gurobi.GRB.INTEGER)

# Set the objective function
model.setObjective(9 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * x1 + 9 * x2 >= 6, name="water_need")
model.addConstr(x1 + x2 >= 33, name="resilience_index")
model.addConstr(x1 + 3 * x2 >= 17, name="beauty_rating")
model.addConstr(2 * x1 + 2 * x2 >= 20, name="cost")
model.addConstr(x1 - 7 * x2 >= 0, name="relationship")
model.addConstr(2 * x1 + 9 * x2 <= 24, name="water_need_upper")
model.addConstr(x1 + x2 <= 90, name="resilience_index_upper")
model.addConstr(x1 + 3 * x2 <= 32, name="beauty_rating_upper")
model.addConstr(2 * x1 + 2 * x2 <= 47, name="cost_upper")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Ferns: ", x1.varValue)
    print("Potato Vines: ", x2.varValue)
else:
    print("The model is infeasible")
