
import gurobipy as gp

# Create a new model
m = gp.Model("network_optimization")

# Create variables
pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
soc_operators = m.addVar(vtype=gp.GRB.INTEGER, name="soc_operators")


# Set objective function
m.setObjective(4.1 * pen_testers + 4.71 * soc_operators, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * pen_testers + 6 * soc_operators >= 5, "min_latency")
m.addConstr(-4 * pen_testers + 2 * soc_operators >= 0, "staffing_ratio")
m.addConstr(2 * pen_testers + 6 * soc_operators <= 25, "max_latency")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('pen_testers:', pen_testers.x)
    print('soc_operators:', soc_operators.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

