
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
x2 = m.addVar(vtype=GRB.INTEGER, name="SOC_operators")

# Set objective function
m.setObjective(4.1*x1 + 4.71*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 6*x2 >= 5, "latency_min")
m.addConstr(-4*x1 + 2*x2 >= 0, "other_constraint")
m.addConstr(2*x1 + 6*x2 <= 25, "latency_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pen Testers: {x1.x}")
    print(f"SOC Operators: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
