
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(vtype=gurobi.GRB.INTEGER, name='pen_testers')
    x2 = model.addVar(vtype=gurobi.GRB.INTEGER, name='SOC_operators')

    # Objective function
    model.setObjective(4.1 * x1 + 4.71 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x1 + 6 * x2 >= 5, name='latency_min')
    model.addConstr(2 * x1 + 6 * x2 <= 34, name='latency_max')
    model.addConstr(-4 * x1 + 2 * x2 >= 0, name='pen_testers_SOC_operators_relationship')

    # Non-negativity constraints are implicitly handled by Gurobi for integer variables

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Number of pen testers: {x1.varValue}')
        print(f'Number of SOC operators: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
