
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    hank_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")
    paul_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")

    # Set objective function
    model.setObjective(2 * hank_hours + 9 * paul_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(27.19 * hank_hours + 23.57 * paul_hours >= 167, "org_score_min")
    model.addConstr(17.72 * hank_hours + 23.11 * paul_hours >= 34, "quit_index_min")
    model.addConstr(22.33 * hank_hours + 15.33 * paul_hours >= 67, "quality_rating_min")
    model.addConstr(2 * hank_hours - 10 * paul_hours >= 0, "hours_relation")
    model.addConstr(27.19 * hank_hours + 23.57 * paul_hours <= 229, "org_score_max")
    model.addConstr(17.72 * hank_hours + 23.11 * paul_hours <= 99, "quit_index_max")
    model.addConstr(22.33 * hank_hours + 15.33 * paul_hours <= 92, "quality_rating_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimal objective value: {model.objVal}")
        print(f"Hours worked by Hank: {hank_hours.x}")
        print(f"Hours worked by Paul: {paul_hours.x}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
