
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")

# Set the objective function
m.setObjective(2*x0 + 9*x1, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(27.19*x0 + 23.57*x1 >= 167, "organization_score_min")
m.addConstr(27.19*x0 + 23.57*x1 <= 229, "organization_score_max")
m.addConstr(17.72*x0 + 23.11*x1 >= 34, "quit_index_min")
m.addConstr(17.72*x0 + 23.11*x1 <= 99, "quit_index_max")
m.addConstr(22.33*x0 + 15.33*x1 >= 67, "work_quality_rating_min")
m.addConstr(22.33*x0 + 15.33*x1 <= 92, "work_quality_rating_max")
m.addConstr(2*x0 - 10*x1 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Hank: {x0.X}")
    print(f"Hours worked by Paul: {x1.X}")
    print(f"Objective function value: {m.ObjVal}")
else:
    print("No optimal solution found.")
