
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="hours_worked_by_Hank", lb=0)
x1 = model.addVar(name="hours_worked_by_Paul", lb=0)

# Define the objective function
model.setObjective(2*x0 + 9*x1, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(27.19*x0 <= 342, name="organization_score_Hank")
model.addConstr(17.72*x0 <= 108, name="likelihood_to_quit_Hank")
model.addConstr(22.33*x0 <= 167, name="work_quality_Hank")
model.addConstr(23.57*x1 <= 342, name="organization_score_Paul")
model.addConstr(23.11*x1 <= 108, name="likelihood_to_quit_Paul")
model.addConstr(15.33*x1 <= 167, name="work_quality_Paul")
model.addConstr(27.19*x0 + 23.57*x1 >= 167, name="combined_organization_score_min")
model.addConstr(17.72*x0 + 23.11*x1 >= 34, name="combined_likelihood_to_quit_min")
model.addConstr(22.33*x0 + 15.33*x1 >= 67, name="combined_work_quality_min")
model.addConstr(2*x0 - 10*x1 >= 0, name="Hank_Paul_hours_constraint")
model.addConstr(27.19*x0 + 23.57*x1 <= 229, name="combined_organization_score_max")
model.addConstr(17.72*x0 + 23.11*x1 <= 99, name="combined_likelihood_to_quit_max")
model.addConstr(22.33*x0 + 15.33*x1 <= 92, name="combined_work_quality_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Hank: {x0.x}")
    print(f"Hours worked by Paul: {x1.x}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
