
from gurobipy import *

# Create a new model
m = Model("Nutrient_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="zinc")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="vitamin_A")
x3 = m.addVar(lb=0, vtype=GRB.INTEGER, name="calcium")
x4 = m.addVar(lb=0, vtype=GRB.INTEGER, name="vitamin_B2")
x5 = m.addVar(lb=0, vtype=GRB.INTEGER, name="iron")
x6 = m.addVar(lb=0, vtype=GRB.INTEGER, name="carbohydrates")
x7 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="magnesium")

# Set objective function
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6 + x7, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 8)
m.addConstr(x1 + x4 >= 8)
m.addConstr(x1 + x5 >= 8)
m.addConstr(x1 + x6 >= 8)
m.addConstr(x2 + x3 >= 8)
m.addConstr(x2 + x4 >= 8)
m.addConstr(x2 + x5 >= 8)
m.addConstr(x2 + x6 >= 8)
m.addConstr(x3 + x4 >= 8)
m.addConstr(x3 + x5 >= 8)
m.addConstr(x3 + x6 >= 8)
m.addConstr(x4 + x5 >= 8)
m.addConstr(x4 + x6 >= 8)
m.addConstr(x5 + x6 >= 8)

# Non-linear constraints
m.addConstr(x1**2 + x2**2 + x3**2 + x4**2 + x5**2 + x6**2 <= 2000)
m.addConstr(x1 + x2 + x3 + x4 + x5 + x6 + x7 <= 10000)

# Integrate model
m.optimize()
