
import gurobi as gp

# Define variables
x = gp.mvar(7, lb=0, ub=None, name="x")

# Define objective function
obj = 5.48*x[0]**2 + 3.8*x[0]*x[1] + 5.65*x[0]*x[2] + 9.36*x[0]*x[3] + 4.61*x[0]*x[4] + 9.94*x[0]*x[5] + 1.41*x[0]*x[6] + \
      8.17*x[1]**2 + 1.38*x[1]*x[2] + 4.76*x[1]*x[3] + 8.36*x[1]*x[4] + 2.99*x[1]*x[5] + 3.98*x[1]*x[6] + \
      8.76*x[2]**2 + 1.42*x[2]*x[3] + 6.35*x[2]*x[5] + 6.91*x[2]*x[6] + 8.12*x[3]**2 + 3.86*x[3]*x[4] + \
      4.21*x[3]*x[5] + 2.84*x[4]**2 + 2.09*x[4]*x[5] + 6.84*x[4]*x[6] + 1.82*x[5]**2 + 2.03*x[5]*x[6] + \
      9.34*x[6]**2 + 8.33*x[0] + 5.83*x[1] + 2.72*x[2] + 3.54*x[3] + 7.69*x[5] + 8.21*x[6]

# Define model
m = gp.Model()

# Add variables to model
m.add_vars(x)

# Set objective
m.set_obj(gp.MAX, obj)

# Add constraints
# Example constraint
m.add_constr(10*x[0] + 9*x[1] + 7*x[2] + 4*x[3] + 2*x[4] + 5*x[5] + 6*x[6] <= 161)

# Solve model
m.optimize()

# Print solution
if m.status == gp.OPTIMAL:
    print("Optimal solution found")
    print("Objective value:", m.obj_val)
    for i in range(7):
        print(f"x[{i}] = {x[i].x}")
else:
    print("No optimal solution found")
