
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B9
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # grams of protein
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # grams of fat


    # Set objective function
    m.setObjective(9*x0 + 7*x1 + 3*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(10*x0 + 11*x1 + 5*x2 <= 99, "r0")
    m.addConstr(5*x0 + 1*x1 + 5*x2 <= 175, "r1")
    m.addConstr(11*x1 + 5*x2 >= 15, "c1")
    m.addConstr(11*x1 + 5*x2 <= 36, "c2")
    m.addConstr(10*x0 + 11*x1 <= 80, "c3")
    m.addConstr(10*x0 + 5*x2 <= 43, "c4")
    m.addConstr(10*x0 + 11*x1 + 5*x2 <= 43, "c5")
    m.addConstr(5*x0 + 5*x2 <= 155, "c6")
    m.addConstr(5*x0 + 1*x1 + 5*x2 <= 96, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status %d" % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
