
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="milligrams_of_vitamin_B9", lb=0)
    x1 = model.addVar(name="grams_of_protein", lb=0)
    x2 = model.addVar(name="grams_of_fat", lb=0)

    # Define objective function
    model.setObjective(9 * x0 + 7 * x1 + 3 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10 * x0 <= 99)
    model.addConstr(5 * x0 <= 175)
    model.addConstr(11 * x1 <= 99)
    model.addConstr(x1 <= 175)
    model.addConstr(5 * x2 <= 99)
    model.addConstr(5 * x2 <= 175)
    model.addConstr(11 * x1 + 5 * x2 >= 15)
    model.addConstr(11 * x1 + 5 * x2 <= 36)
    model.addConstr(10 * x0 + 11 * x1 <= 80)
    model.addConstr(10 * x0 + 5 * x2 <= 43)
    model.addConstr(10 * x0 + 11 * x1 + 5 * x2 <= 43)
    model.addConstr(5 * x0 + 5 * x2 <= 155)
    model.addConstr(5 * x0 + x1 + 5 * x2 <= 96)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B9: {x0.varValue}")
        print(f"Grams of protein: {x1.varValue}")
        print(f"Grams of fat: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
