
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_A") # milligrams of vitamin A (integer)
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_B5") # milligrams of vitamin B5

    # Set objective function
    m.setObjective(2.09 * x0 + 2.11 * x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7 * x0 + 22 * x1 >= 13, "c0")
    m.addConstr(5 * x0 + 26 * x1 >= 45, "c1")
    m.addConstr(16 * x0 + 26 * x1 >= 37, "c2")
    m.addConstr(-7 * x0 + 3 * x1 >= 0, "c3")
    m.addConstr(7 * x0 + 22 * x1 <= 58, "c4")
    m.addConstr(5 * x0 + 26 * x1 <= 133, "c5")
    m.addConstr(16 * x0 + 26 * x1 <= 61, "c6")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Vitamin A: %g' % x0.x)
        print('Vitamin B5: %g' % x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
