
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_A")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B5")

# Set the objective function
m.setObjective(2.09*x1 + 2.11*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(7*x1 + 22*x2 >= 13, "cognitive_performance_index_min")
m.addConstr(5*x1 + 26*x2 >= 45, "kidney_support_index_min")
m.addConstr(16*x1 + 26*x2 >= 37, "cardiovascular_support_index_min")
m.addConstr(-7*x1 + 3*x2 >= 0, "mixed_constraint_1")
m.addConstr(7*x1 + 22*x2 <= 58, "cognitive_performance_index_max")
m.addConstr(5*x1 + 26*x2 <= 133, "kidney_support_index_max")
m.addConstr(16*x1 + 26*x2 <= 61, "cardiovascular_support_index_max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin A: {x1.x}")
    print(f"Milligrams of Vitamin B5: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
