
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_vitamin_A", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="milligrams_of_vitamin_B5")

    # Objective function
    model.setObjective(2.09 * x1 + 2.11 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7 * x1 + 22 * x2 >= 13, name="cognitive_performance_index")
    model.addConstr(5 * x1 + 26 * x2 >= 45, name="kidney_support_index")
    model.addConstr(16 * x1 + 26 * x2 >= 37, name="cardiovascular_support_index")
    model.addConstr(-7 * x1 + 3 * x2 >= 0, name="vitamin_interaction")
    model.addConstr(7 * x1 + 22 * x2 <= 58, name="max_cognitive_performance_index")
    model.addConstr(5 * x1 + 26 * x2 <= 133, name="max_kidney_support_index")
    model.addConstr(16 * x1 + 26 * x2 <= 61, name="max_cardiovascular_support_index")

    # Bounds
    model.addConstr(x1 >= 0, name="non_negative_x1")
    model.addConstr(x1 <= 70, name="max_x1")
    model.addConstr(x2 >= 0, name="non_negative_x2")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin A: {x1.varValue}")
        print(f"Milligrams of vitamin B5: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
