
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
apples = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")
green_beans = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="green_beans")
cornichons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")


# Set objective function
m.setObjective(2.93 * apples + 2.28 * green_beans + 9.24 * cornichons, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * apples + 11 * cornichons >= 70, "c0")
m.addConstr(8 * apples + 6 * green_beans + 11 * cornichons >= 70, "c1")
m.addConstr(17 * green_beans + 12 * cornichons >= 31, "c2")
m.addConstr(23 * apples + 12 * cornichons >= 33, "c3")
m.addConstr(23 * apples + 17 * green_beans + 12 * cornichons >= 33, "c4")
m.addConstr(-2 * apples + 2 * green_beans >= 0, "c5")
m.addConstr(9 * apples - 5 * cornichons >= 0, "c6")
m.addConstr(6 * green_beans + 11 * cornichons <= 155, "c7")
m.addConstr(8 * apples + 6 * green_beans + 11 * cornichons <= 182, "c8")
m.addConstr(17 * green_beans + 12 * cornichons <= 108, "c9")
m.addConstr(23 * apples + 17 * green_beans <= 64, "c10")
m.addConstr(23 * apples + 17 * green_beans + 12 * cornichons <= 87, "c11")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

