
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
bill_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
dale_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")
jean_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean_hours")
mary_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary_hours")

# Set objective function
model.setObjective(9 * bill_hours + 7 * dale_hours + 1 * jean_hours + 5 * mary_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * dale_hours + 17 * mary_hours >= 26)
model.addConstr(4 * bill_hours + 19 * jean_hours >= 11)
model.addConstr(6 * dale_hours + 19 * jean_hours >= 18)
model.addConstr(4 * bill_hours + 6 * dale_hours + 19 * jean_hours + 17 * mary_hours >= 18)
model.addConstr(4 * bill_hours + 19 * jean_hours >= 36)
model.addConstr(14 * dale_hours + 19 * jean_hours >= 19)
model.addConstr(4 * bill_hours + 14 * dale_hours + 19 * jean_hours + 8 * mary_hours >= 19)
model.addConstr(6 * bill_hours + 3 * mary_hours >= 17)
model.addConstr(2 * jean_hours + 3 * mary_hours >= 42)
model.addConstr(6 * bill_hours + 2 * dale_hours >= 19)
model.addConstr(6 * bill_hours + 2 * jean_hours >= 35)
model.addConstr(2 * dale_hours + 2 * jean_hours >= 38)
model.addConstr(2 * dale_hours + 3 * mary_hours >= 38)
model.addConstr(6 * bill_hours + 2 * dale_hours + 2 * jean_hours + 3 * mary_hours >= 38)
model.addConstr(15 * bill_hours + 3 * dale_hours >= 58)
model.addConstr(15 * bill_hours + 9 * mary_hours >= 63)
model.addConstr(20 * jean_hours + 9 * mary_hours >= 74)
model.addConstr(3 * dale_hours + 20 * jean_hours >= 45)
model.addConstr(3 * dale_hours + 9 * mary_hours >= 63)
model.addConstr(15 * bill_hours + 20 * jean_hours + 9 * mary_hours >= 74)
model.addConstr(15 * bill_hours + 3 * dale_hours + 20 * jean_hours + 9 * mary_hours >= 74)
model.addConstr(-3 * bill_hours + 1 * dale_hours >= 0)
model.addConstr(6 * dale_hours + 19 * jean_hours <= 113)
model.addConstr(4 * bill_hours + 19 * jean_hours <= 116)
model.addConstr(6 * dale_hours + 17 * mary_hours <= 122)
model.addConstr(19 * jean_hours + 17 * mary_hours <= 85)
model.addConstr(4 * bill_hours + 6 * dale_hours <= 101)
model.addConstr(4 * bill_hours + 6 * dale_hours + 19 * jean_hours <= 65)
model.addConstr(4 * bill_hours + 19 * jean_hours + 17 * mary_hours <= 63)
model.addConstr(4 * bill_hours + 19 * jean_hours <= 104)
model.addConstr(14 * dale_hours + 19 * jean_hours <= 88)
model.addConstr(4 * bill_hours + 19 * jean_hours + 8 * mary_hours <= 171)
model.addConstr(4 * bill_hours + 14 * dale_hours + 19 * jean_hours <= 117)
model.addConstr(14 * dale_hours + 19 * jean_hours + 8 * mary_hours <= 72)
model.addConstr(2 * dale_hours + 2 * jean_hours <= 147)
model.addConstr(6 * bill_hours + 2 * dale_hours + 2 * jean_hours <= 86)
model.addConstr(15 * bill_hours + 9 * mary_hours <= 258)
model.addConstr(3 * dale_hours + 9 * mary_hours <= 210)
model.addConstr(15 * bill_hours + 20 * jean_hours <= 237)
model.addConstr(3 * dale_hours + 20 * jean_hours <= 264)
model.addConstr(15 * bill_hours + 3 * dale_hours <= 211)
model.addConstr(15 * bill_hours + 20 * jean_hours + 9 * mary_hours <= 181)
model.addConstr(3 * dale_hours + 20 * jean_hours + 9 * mary_hours <= 259)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

