
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Bill
x1 = m.addVar(name="x1", lb=0)  # hours worked by Dale
x2 = m.addVar(name="x2", lb=0)  # hours worked by Jean
x3 = m.addVar(name="x3", lb=0)  # hours worked by Mary

# Objective function
m.setObjective(9 * x0 + 7 * x1 + x2 + 5 * x3, gurobi.GRB.MINIMIZE)

# Constraints
# Individual constraints
m.addConstr(4 * x0 <= 139)
m.addConstr(4 * x0 <= 189)
m.addConstr(6 * x0 <= 179)
m.addConstr(15 * x0 <= 330)

m.addConstr(6 * x1 <= 139)
m.addConstr(14 * x1 <= 189)
m.addConstr(2 * x1 <= 179)
m.addConstr(3 * x1 <= 330)

m.addConstr(19 * x2 <= 139)
m.addConstr(19 * x2 <= 189)
m.addConstr(2 * x2 <= 179)
m.addConstr(20 * x2 <= 330)

m.addConstr(17 * x3 <= 139)
m.addConstr(8 * x3 <= 189)
m.addConstr(3 * x3 <= 179)
m.addConstr(9 * x3 <= 330)

# Combined constraints
m.addConstr(6 * x1 + 17 * x3 >= 26)
m.addConstr(4 * x0 + 19 * x2 >= 11)
m.addConstr(6 * x1 + 19 * x2 >= 18)
m.addConstr(4 * x0 + 6 * x1 + 19 * x2 + 17 * x3 >= 18)

m.addConstr(4 * x0 + 19 * x2 >= 36)
m.addConstr(14 * x1 + 19 * x2 >= 19)
m.addConstr(4 * x0 + 14 * x1 + 19 * x2 + 8 * x3 >= 19)

m.addConstr(6 * x0 + 3 * x3 >= 17)
m.addConstr(2 * x2 + 3 * x3 >= 42)
m.addConstr(6 * x0 + 2 * x1 >= 19)
m.addConstr(6 * x0 + 2 * x2 >= 35)
m.addConstr(2 * x1 + 2 * x2 >= 38)
m.addConstr(2 * x1 + 3 * x3 >= 38)
m.addConstr(6 * x0 + 2 * x1 + 2 * x2 + 3 * x3 >= 38)

m.addConstr(15 * x0 + 3 * x1 >= 58)
m.addConstr(15 * x0 + 9 * x3 >= 63)
m.addConstr(20 * x2 + 9 * x3 >= 74)
m.addConstr(3 * x1 + 20 * x2 >= 45)
m.addConstr(3 * x1 + 9 * x3 >= 63)
m.addConstr(15 * x0 + 20 * x2 + 9 * x3 >= 74)
m.addConstr(15 * x0 + 3 * x1 + 20 * x2 + 9 * x3 >= 74)

m.addConstr(-3 * x0 + x1 >= 0)

m.addConstr(6 * x1 + 19 * x2 <= 113)
m.addConstr(4 * x0 + 19 * x2 <= 116)
m.addConstr(6 * x1 + 17 * x3 <= 122)
m.addConstr(19 * x2 + 17 * x3 <= 85)
m.addConstr(4 * x0 + 6 * x1 <= 101)
m.addConstr(4 * x0 + 19 * x2 <= 65)
m.addConstr(4 * x0 + 19 * x2 + 17 * x3 <= 63)

m.addConstr(4 * x0 + 19 * x2 <= 104)
m.addConstr(14 * x1 + 19 * x2 <= 88)
m.addConstr(4 * x0 + 19 * x2 + 8 * x3 <= 171)
m.addConstr(4 * x0 + 14 * x1 + 19 * x2 <= 117)
m.addConstr(14 * x1 + 19 * x2 + 8 * x3 <= 72)

m.addConstr(2 * x1 + 2 * x2 <= 147)
m.addConstr(6 * x0 + 2 * x1 + 2 * x2 <= 86)

m.addConstr(15 * x0 + 9 * x3 <= 258)
m.addConstr(3 * x1 + 9 * x3 <= 210)
m.addConstr(15 * x0 + 20 * x2 <= 237)
m.addConstr(3 * x1 + 20 * x2 <= 264)
m.addConstr(15 * x0 + 3 * x1 <= 211)
m.addConstr(15 * x0 + 20 * x2 + 9 * x3 <= 181)
m.addConstr(3 * x1 + 20 * x2 + 9 * x3 <= 259)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bill: ", x0.varValue)
    print("Hours worked by Dale: ", x1.varValue)
    print("Hours worked by Jean: ", x2.varValue)
    print("Hours worked by Mary: ", x3.varValue)
else:
    print("The model is infeasible")
