
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(name="grams_of_fat")
    x1 = m.addVar(name="milligrams_of_iron")
    x2 = m.addVar(name="milligrams_of_magnesium")


    # Set objective function
    m.setObjective(7*x0**2 + 5*x0*x1 + 6*x0*x2 + 5*x1**2 + 1*x1*x2 + 5*x2**2 + 3*x0 + 5*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4*x0 + 11*x1 + 9*x2 <= 228, "r0")
    m.addConstr(22*x0 + 26*x1 + 2*x2 <= 271, "r1")
    m.addConstr(4*x0 + 9*x2 >= 67, "c1")
    m.addConstr(11*x1 + 9*x2 >= 40, "c2")
    m.addConstr(4*x0**2 + 11*x1**2 >= 39, "c3")
    m.addConstr(4*x0 + 11*x1 + 9*x2 >= 39, "c4")
    m.addConstr(22*x0 + 26*x1 >= 54, "c5")
    m.addConstr(22*x0 + 2*x2 >= 70, "c6")
    m.addConstr(22*x0 + 26*x1 + 2*x2 >= 70, "c7")
    m.addConstr(9*x0 - 5*x2 >= 0, "c8")
    m.addConstr(4*x0 + 11*x1 <= 214, "c9")
    m.addConstr(22*x0**2 + 2*x2**2 <= 258, "c10")
    m.addConstr(26*x1 + 2*x2 <= 216, "c11")
    m.addConstr(22*x0 + 26*x1 <= 247, "c12")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName} = {v.x}')
        print(f'Objective value: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
