
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, vtype=gp.GRB.INTEGER, name=["scissors", "blue highlighters", "usb flash drives", "packs of paper", "monochrome printers", "black pens"])


# Set objective function
m.setObjective(1.1 * x[0] + 5.84 * x[1] + 1.65 * x[2] + 1.77 * x[3] + 2.02 * x[4] + 2.28 * x[5], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(12 * x[0] + 5 * x[1] + 19 * x[2] + 15 * x[3] + 2 * x[4] + 19 * x[5] <= 251, "r0")
m.addConstr(4 * x[0] + 16 * x[1] + 12 * x[2] + 18 * x[3] + 17 * x[4] + 5 * x[5] <= 384, "r1")
m.addConstr(15 * x[3] + 2 * x[4] >= 14, "c1")
m.addConstr(19 * x[2] + 2 * x[4] >= 21, "c2")
m.addConstr(12 * x[0] + 5 * x[1] >= 31, "c3")
m.addConstr(12 * x[0] + 15 * x[3] >= 25, "c4")
m.addConstr(12 * x[0] + 15 * x[3] + 19 * x[5] >= 37, "c5")
m.addConstr(12 * x[0] + 5 * x[1] + 19 * x[2] + 15 * x[3] + 2 * x[4] + 19 * x[5] >= 37, "c6")
m.addConstr(16 * x[1] + 5 * x[5] >= 22, "c7")
m.addConstr(4 * x[0] + 17 * x[4] >= 25, "c8")
m.addConstr(16 * x[1] + 12 * x[2] >= 24, "c9")
m.addConstr(12 * x[2] + 18 * x[3] >= 37, "c10")
m.addConstr(12 * x[2] + 5 * x[5] >= 60, "c11")
m.addConstr(16 * x[1] + 12 * x[2] + 17 * x[4] >= 64, "c12")
m.addConstr(4 * x[0] + 16 * x[1] + 17 * x[4] >= 64, "c13")
m.addConstr(12 * x[2] + 18 * x[3] + 17 * x[4] >= 64, "c14")
m.addConstr(4 * x[0] + 16 * x[1] + 12 * x[2] >= 64, "c15")
m.addConstr(18 * x[3] + 17 * x[4] + 5 * x[5] >= 64, "c16")
m.addConstr(16 * x[1] + 18 * x[3] + 5 * x[5] >= 64, "c17")

# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

