
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="3D_printers")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="black_pens")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="postage_stamps")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="monochrome_printers")

# Set objective function
m.setObjective(1*x0 + 8*x1 + 7*x2 + 5*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x0 + 17*x1 + 11*x2 + 3*x3 <= 152, "weight")
m.addConstr(11*x0 + 1*x1 + 11*x2 + 13*x3 <= 120, "employee_satisfaction_impact")
m.addConstr(14*x0 + 15*x1 + 17*x2 + 1*x3 <= 136, "dollar_cost")
m.addConstr(2*x0 + 17*x1 + 2*x2 + 7*x3 <= 94, "workplace_safety_impact")
m.addConstr(11*x0 + 1*x1 >= 20, "c5")
m.addConstr(11*x0 + 11*x2 + 13*x3 >= 29, "c6")
m.addConstr(14*x0 + 15*x1 + 1*x3 >= 27, "c7")
m.addConstr(2*x0 + 2*x2 >= 23, "c8")
m.addConstr(17*x1 + 7*x3 >= 10, "c9")
m.addConstr(2*x2 + 7*x3 >= 15, "c10")
m.addConstr(4*x0 + 3*x3 <= 116, "c11")
m.addConstr(4*x0 + 17*x1 <= 104, "c12")
m.addConstr(4*x0 + 11*x2 <= 72, "c13")
m.addConstr(11*x2 + 3*x3 <= 61, "c14")
m.addConstr(4*x0 + 17*x1 + 11*x2 + 3*x3 <= 61, "c15")
m.addConstr(11*x0 + 11*x2 <= 107, "c16")
m.addConstr(11*x0 + 1*x1 <= 31, "c17")
m.addConstr(11*x0 + 13*x3 <= 38, "c18")
m.addConstr(11*x2 + 13*x3 <= 46, "c19")
m.addConstr(1*x1 + 13*x3 <= 115, "c20")
m.addConstr(11*x0 + 1*x1 + 11*x2 <= 99, "c21")
m.addConstr(1*x1 + 11*x2 + 13*x3 <= 107, "c22")
m.addConstr(11*x0 + 11*x2 + 13*x3 <= 93, "c23")
m.addConstr(11*x0 + 1*x1 + 11*x2 + 13*x3 <= 93, "c24")
m.addConstr(14*x0 + 15*x1 <= 40, "c25")
m.addConstr(15*x1 + 17*x2 <= 129, "c26")
m.addConstr(14*x0 + 1*x3 <= 47, "c27")
m.addConstr(14*x0 + 15*x1 + 1*x3 <= 110, "c28")
m.addConstr(14*x0 + 15*x1 + 17*x2 + 1*x3 <= 110, "c29")
m.addConstr(2*x0 + 7*x3 <= 78, "c30")
m.addConstr(2*x0 + 17*x1 <= 68, "c31")
m.addConstr(2*x2 + 7*x3 <= 55, "c32")
m.addConstr(17*x1 + 2*x2 + 7*x3 <= 64, "c33")
m.addConstr(2*x0 + 17*x1 + 7*x3 <= 83, "c34")
m.addConstr(2*x0 + 2*x2 + 7*x3 <= 43, "c35")
m.addConstr(2*x0 + 17*x1 + 2*x2 <= 81, "c36")
m.addConstr(2*x0 + 17*x1 + 2*x2 + 7*x3 <= 81, "c37")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

