
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='3D_printers', vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name='black_pens', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='postage_stamps', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='monochrome_printers', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(1*x0 + 8*x1 + 7*x2 + 5*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4*x0 + 17*x1 + 11*x2 + 3*x3 <= 152)
    model.addConstr(11*x0 + x1 + 11*x2 + 13*x3 <= 120)
    model.addConstr(14*x0 + 15*x1 + 17*x2 + x3 <= 136)
    model.addConstr(2*x0 + 17*x1 + 2*x2 + 7*x3 <= 94)
    model.addConstr(11*x0 + x1 >= 20)
    model.addConstr(11*x0 + 11*x2 + 13*x3 >= 29)
    model.addConstr(14*x0 + 15*x1 + x3 >= 27)
    model.addConstr(2*x0 + 2*x2 >= 23)
    model.addConstr(17*x1 + 7*x3 >= 10)
    model.addConstr(2*x2 + 7*x3 >= 15)
    model.addConstr(4*x0 + 3*x3 <= 116)
    model.addConstr(4*x0 + 17*x1 <= 104)
    model.addConstr(4*x0 + 11*x2 <= 72)
    model.addConstr(11*x2 + 3*x3 <= 61)
    model.addConstr(4*x0 + 17*x1 + 11*x2 + 3*x3 <= 61)
    model.addConstr(11*x0 + 11*x2 <= 107)
    model.addConstr(11*x0 + x1 <= 31)
    model.addConstr(11*x0 + 13*x3 <= 38)
    model.addConstr(11*x2 + 13*x3 <= 46)
    model.addConstr(x1 + 13*x3 <= 115)
    model.addConstr(11*x0 + x1 + 11*x2 <= 99)
    model.addConstr(x1 + 11*x2 + 13*x3 <= 107)
    model.addConstr(11*x0 + 11*x2 + 13*x3 <= 93)
    model.addConstr(11*x0 + x1 + 11*x2 + 13*x3 <= 93)
    model.addConstr(14*x0 + 15*x1 <= 40)
    model.addConstr(15*x1 + 17*x2 <= 129)
    model.addConstr(14*x0 + x3 <= 47)
    model.addConstr(14*x0 + 15*x1 + x3 <= 110)
    model.addConstr(14*x0 + 15*x1 + 17*x2 + x3 <= 110)
    model.addConstr(2*x0 + 7*x3 <= 78)
    model.addConstr(2*x0 + 17*x1 <= 68)
    model.addConstr(2*x2 + 7*x3 <= 55)
    model.addConstr(17*x1 + 2*x2 + 7*x3 <= 64)
    model.addConstr(2*x0 + 17*x1 + 7*x3 <= 83)
    model.addConstr(2*x0 + 2*x2 + 7*x3 <= 43)
    model.addConstr(2*x0 + 17*x1 + 2*x2 <= 81)
    model.addConstr(2*x0 + 17*x1 + 2*x2 + 7*x3 <= 81)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('3D printers: ', x0.varValue)
        print('black pens: ', x1.varValue)
        print('postage stamps: ', x2.varValue)
        print('monochrome printers: ', x3.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
