
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    strawberries = m.addVar(lb=0, name="strawberries")
    hot_dogs = m.addVar(lb=0, name="hot_dogs")
    kiwis = m.addVar(lb=0, name="kiwis")

    # Set objective function
    m.setObjective(3.13 * strawberries + 3.77 * hot_dogs + 3.2 * kiwis, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2 * strawberries + 20 * kiwis >= 167, "c1")
    m.addConstr(2 * strawberries + 28 * hot_dogs >= 200, "c2")
    m.addConstr(2 * strawberries + 28 * hot_dogs + 20 * kiwis >= 121, "c3")
    m.addConstr(2 * strawberries + 20 * kiwis <= 430, "c4")
    m.addConstr(2 * strawberries + 28 * hot_dogs <= 311, "c5")
    m.addConstr(2 * strawberries + 28 * hot_dogs + 20 * kiwis <= 640, "c6")  # dollar cost
    m.addConstr(20 * strawberries + 2 * kiwis <= 289, "c7")
    m.addConstr(6 * hot_dogs + 2 * kiwis <= 586, "c8")
    m.addConstr(20 * strawberries + 6 * hot_dogs + 2 * kiwis <= 708, "c9")  # fiber
    m.addConstr(32 * strawberries + 19 * hot_dogs <= 89, "c10")
    m.addConstr(32 * strawberries + 5 * kiwis <= 66, "c11")
    m.addConstr(19 * hot_dogs + 5 * kiwis <= 88, "c12")
    m.addConstr(32 * strawberries + 19 * hot_dogs + 5 * kiwis <= 95, "c13")  # tastiness
    m.addConstr(31 * strawberries + 7 * hot_dogs <= 453, "c14")
    m.addConstr(7 * hot_dogs + 30 * kiwis <= 567, "c15")
    m.addConstr(31 * strawberries + 7 * hot_dogs + 30 * kiwis <= 652, "c16")  # sourness


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('strawberries:', strawberries.x)
        print('hot_dogs:', hot_dogs.x)
        print('kiwis:', kiwis.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
