
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="strawberries", lb=0)
x2 = m.addVar(name="hot dogs", lb=0)
x3 = m.addVar(name="kiwis", lb=0)

# Define the objective function
m.setObjective(3.13 * x1 + 3.77 * x2 + 3.2 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * x1 + 28 * x2 + 20 * x3 <= 640)
m.addConstr(20 * x1 + 6 * x2 + 2 * x3 <= 708)
m.addConstr(32 * x1 + 19 * x2 + 5 * x3 <= 95)
m.addConstr(31 * x1 + 7 * x2 + 30 * x3 <= 652)
m.addConstr(2 * x1 + 20 * x3 >= 167)
m.addConstr(2 * x1 + 28 * x2 >= 200)
m.addConstr(2 * x1 + 28 * x2 + 20 * x3 >= 121)
m.addConstr(2 * x1 + 20 * x3 <= 430)
m.addConstr(2 * x1 + 28 * x2 <= 311)
m.addConstr(2 * x1 + 28 * x2 + 20 * x3 <= 311)
m.addConstr(20 * x1 + 2 * x3 <= 289)
m.addConstr(6 * x2 + 2 * x3 <= 586)
m.addConstr(20 * x1 + 6 * x2 + 2 * x3 <= 695)
m.addConstr(32 * x1 + 19 * x2 <= 89)
m.addConstr(32 * x1 + 5 * x3 <= 66)
m.addConstr(19 * x2 + 5 * x3 <= 88)
m.addConstr(32 * x1 + 19 * x2 + 5 * x3 <= 88)
m.addConstr(31 * x1 + 7 * x2 <= 453)
m.addConstr(7 * x2 + 30 * x3 <= 567)
m.addConstr(31 * x1 + 7 * x2 + 30 * x3 <= 567)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Strawberries: ", x1.varValue)
    print("Hot Dogs: ", x2.varValue)
    print("Kiwis: ", x3.varValue)
else:
    print("The model is infeasible")
