
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_magnesium")
    x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="milligrams_of_vitamin_B4")


    # Set objective function
    m.setObjective(5.65 * x0 + 3.36 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(9 * x0 + 4 * x1 >= 15, "c0")
    m.addConstr(6 * x0 - 3 * x1 >= 0, "c1")
    m.addConstr(9 * x0 + 4 * x1 <= 29, "c2")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", m.objVal)
        print("milligrams_of_magnesium:", x0.x)
        print("milligrams_of_vitamin_B4:", x1.x)

except gp.GurobiError as e:
    print("Error code " + str(e.errno) + ": " + str(e))

except AttributeError:
    print("Encountered an attribute error")

