
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Add variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_magnesium")
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B4")

# Set the objective function
model.setObjective(5.65*x1 + 3.36*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(9*x1 + 4*x2 >= 15, "immune_support_lower_bound")
model.addConstr(6*x1 - 3*x2 >= 0, "magnesium_vitamin_B4_ratio")
model.addConstr(9*x1 + 4*x2 <= 48, "total_immune_support_upper_bound")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Magnesium: {x1.x}")
    print(f"Milligrams of Vitamin B4: {x2.x}")
    print(f"Objective Function Value: {model.objVal}")
else:
    print("No optimal solution found")
