
import gurobipy as gp

# Create a new model
m = gp.Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name="milligrams_of_magnesium", lb=0)  # Assuming non-negative
x2 = m.addVar(name="milligrams_of_vitamin_B4", lb=0, integrality=0)  # Can be fractional

# Objective function
m.setObjective(5.65*x1 + 3.36*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(9*x1 + 4*x2 >= 15, name="immune_support_index_min")
m.addConstr(6*x1 - 3*x2 >= 0, name="six_magnesium_minus_three_B4")
m.addConstr(9*x1 + 4*x2 <= 29, name="immune_support_index_max")

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of magnesium: {x1.varValue}")
    print(f"Milligrams of vitamin B4: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
