
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_fat")
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B5")
    x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_zinc")


    # Set objective function
    m.setObjective(3.69 * x0 + 9.03 * x1 + 5.22 * x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(0.39 * x0 + 0.41 * x1 >= 37, "c0")
    m.addConstr(0.39 * x0 + 0.41 * x1 + 0.33 * x2 >= 62, "c1")
    m.addConstr(7 * x1 - x2 >= 0, "c2")
    m.addConstr(0.76 * x0 + 0.2 * x1 <= 90, "c3")
    m.addConstr(0.76 * x0 + 0.16 * x2 <= 90, "c4")
    m.addConstr(0.76 * x0 + 0.2 * x1 + 0.16 * x2 <= 58, "c5")
    m.addConstr(0.39 * x0 + 0.33 * x2 <= 169, "c6")
    m.addConstr(0.39 * x0 + 0.41 * x1 <= 106, "c7")
    m.addConstr(0.41 * x1 + 0.33 * x2 <= 161, "c8")
    m.addConstr(0.39 * x0 + 0.41 * x1 + 0.33 * x2 <= 161, "c9")
    m.addConstr(0.1 * x1 + 0.7 * x2 <= 84, "c10")
    m.addConstr(0.92 * x0 + 0.7 * x2 <= 67, "c11")
    m.addConstr(0.92 * x0 + 0.1 * x1 + 0.7 * x2 <= 67, "c12")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
