
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # grams of fat
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B5
    x3 = model.addVar(name="x3", lb=0, type=gurobi.GRB.INTEGER)  # milligrams of zinc

    # Define the objective function
    model.setObjective(3.69 * x1 + 9.03 * x2 + 5.22 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.76 * x1 <= 116)
    model.addConstr(0.39 * x1 <= 203)
    model.addConstr(0.92 * x1 <= 99)
    model.addConstr(0.2 * x2 <= 116)
    model.addConstr(0.41 * x2 <= 203)
    model.addConstr(0.1 * x2 <= 99)
    model.addConstr(0.16 * x3 <= 116)
    model.addConstr(0.33 * x3 <= 203)
    model.addConstr(0.7 * x3 <= 99)
    model.addConstr(0.39 * x1 + 0.41 * x2 >= 37)
    model.addConstr(0.39 * x1 + 0.41 * x2 + 0.33 * x3 >= 62)
    model.addConstr(7 * x2 - x3 >= 0)
    model.addConstr(0.76 * x1 + 0.2 * x2 <= 90)
    model.addConstr(0.76 * x1 + 0.16 * x3 <= 90)
    model.addConstr(0.76 * x1 + 0.2 * x2 + 0.16 * x3 <= 58)
    model.addConstr(0.39 * x1 + 0.33 * x3 <= 169)
    model.addConstr(0.39 * x1 + 0.41 * x2 <= 106)
    model.addConstr(0.41 * x2 + 0.33 * x3 <= 161)
    model.addConstr(0.39 * x1 + 0.41 * x2 + 0.33 * x3 <= 161)
    model.addConstr(0.1 * x2 + 0.7 * x3 <= 84)
    model.addConstr(0.92 * x1 + 0.7 * x3 <= 67)
    model.addConstr(0.92 * x1 + 0.1 * x2 + 0.7 * x3 <= 67)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Objective: {model.objVal}")
        print(f"Grams of fat: {x1.varValue}")
        print(f"Milligrams of vitamin B5: {x2.varValue}")
        print(f"Milligrams of zinc: {x3.varValue}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
