
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")


# Set objective function
m.setObjective(7 * ringo + 1 * paul + 8 * peggy + 6 * mary, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * paul + 4 * mary >= 7)
m.addConstr(2 * ringo + 12 * peggy >= 7)
m.addConstr(14 * paul + 12 * peggy >= 14)
m.addConstr(2 * ringo + 14 * paul >= 9)
m.addConstr(2 * ringo + 14 * paul + 12 * peggy >= 21)
m.addConstr(2 * ringo + 14 * paul + 4 * mary >= 21)
m.addConstr(2 * ringo + 14 * paul + 12 * peggy >= 19)
m.addConstr(2 * ringo + 14 * paul + 4 * mary >= 19)
m.addConstr(2 * ringo + 14 * paul + 12 * peggy + 4 * mary >= 19)
m.addConstr(7 * paul + 1 * peggy >= 32)
m.addConstr(1 * peggy + 2 * mary >= 28)
m.addConstr(7 * paul + 2 * mary >= 35)
m.addConstr(8 * ringo + 7 * paul + 2 * mary >= 34)
m.addConstr(8 * ringo + 7 * paul + 1 * peggy >= 34)
m.addConstr(7 * paul + 1 * peggy + 2 * mary >= 34)
m.addConstr(8 * ringo + 7 * paul + 2 * mary >= 33)
m.addConstr(8 * ringo + 7 * paul + 1 * peggy >= 33)
m.addConstr(7 * paul + 1 * peggy + 2 * mary >= 33)
m.addConstr(8 * ringo + 7 * paul + 2 * mary >= 35)
m.addConstr(8 * ringo + 7 * paul + 1 * peggy >= 35)
m.addConstr(7 * paul + 1 * peggy + 2 * mary >= 35)
m.addConstr(8 * ringo + 7 * paul + 1 * peggy + 2 * mary >= 35)
m.addConstr(8 * ringo - 3 * peggy >= 0)
m.addConstr(14 * paul + 4 * mary <= 81)
m.addConstr(14 * paul + 12 * peggy <= 86)
m.addConstr(14 * paul + 12 * peggy + 4 * mary <= 56)
m.addConstr(2 * ringo + 14 * paul + 4 * mary <= 62)
m.addConstr(7 * paul + 1 * peggy <= 95)
m.addConstr(1 * peggy + 2 * mary <= 152)
m.addConstr(8 * ringo + 1 * peggy + 2 * mary <= 113)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("The model could not be solved to optimality.")

