
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Ringo
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Paul
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Peggy
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Mary

    # Objective function
    model.setObjective(7 * x0 + 1 * x1 + 8 * x2 + 6 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x0 <= 95)
    model.addConstr(8 * x0 <= 163)
    model.addConstr(14 * x1 <= 95)
    model.addConstr(7 * x1 <= 163)
    model.addConstr(12 * x2 <= 95)
    model.addConstr(1 * x2 <= 163)
    model.addConstr(4 * x3 <= 95)
    model.addConstr(2 * x3 <= 163)
    model.addConstr(14 * x1 + 4 * x3 >= 7)
    model.addConstr(2 * x0 + 12 * x2 >= 7)
    model.addConstr(14 * x1 + 12 * x2 >= 14)
    model.addConstr(2 * x0 + 14 * x1 >= 9)
    model.addConstr(2 * x0 + 14 * x1 + 12 * x2 >= 21)
    model.addConstr(2 * x0 + 14 * x1 + 4 * x3 >= 21)
    model.addConstr(2 * x0 + 14 * x1 + 12 * x2 >= 19)
    model.addConstr(2 * x0 + 14 * x1 + 4 * x3 >= 19)
    model.addConstr(2 * x0 + 14 * x1 + 12 * x2 + 4 * x3 >= 19)
    model.addConstr(7 * x1 + 1 * x2 >= 32)
    model.addConstr(1 * x2 + 2 * x3 >= 28)
    model.addConstr(7 * x1 + 2 * x3 >= 35)
    model.addConstr(8 * x0 + 7 * x1 + 2 * x3 >= 34)
    model.addConstr(8 * x0 + 7 * x1 + 1 * x2 >= 34)
    model.addConstr(7 * x1 + 1 * x2 + 2 * x3 >= 34)
    model.addConstr(8 * x0 + 7 * x1 + 2 * x3 >= 33)
    model.addConstr(8 * x0 + 7 * x1 + 1 * x2 >= 33)
    model.addConstr(7 * x1 + 1 * x2 + 2 * x3 >= 33)
    model.addConstr(8 * x0 + 7 * x1 + 2 * x3 >= 35)
    model.addConstr(8 * x0 + 7 * x1 + 1 * x2 >= 35)
    model.addConstr(7 * x1 + 1 * x2 + 2 * x3 >= 35)
    model.addConstr(8 * x0 + 7 * x1 + 1 * x2 + 2 * x3 >= 35)
    model.addConstr(8 * x0 - 3 * x2 >= 0)
    model.addConstr(14 * x1 + 4 * x3 <= 81)
    model.addConstr(14 * x1 + 12 * x2 <= 86)
    model.addConstr(14 * x1 + 12 * x2 + 4 * x3 <= 56)
    model.addConstr(2 * x0 + 14 * x1 + 4 * x3 <= 62)
    model.addConstr(7 * x1 + 1 * x2 <= 95)
    model.addConstr(1 * x2 + 2 * x3 <= 152)
    model.addConstr(8 * x0 + 1 * x2 + 2 * x3 <= 113)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
