
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
    vitamin_a = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_a")


    # Set objective function
    m.setObjective(5 * potassium + 3 * vitamin_a, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(17 * potassium + 5 * vitamin_a >= 49, "kidney_support_min")
    m.addConstr(21 * potassium + 23 * vitamin_a >= 120, "energy_stability_min")
    m.addConstr(24 * potassium + 24 * vitamin_a >= 95, "immune_support_min")
    m.addConstr(21 * potassium + 6 * vitamin_a >= 161, "muscle_growth_min")
    m.addConstr(3 * potassium + 17 * vitamin_a >= 86, "cognitive_performance_min")
    m.addConstr(3 * potassium - 9 * vitamin_a >= 0, "potassium_vitamin_a_ratio")

    m.addConstr(17 * potassium + 5 * vitamin_a <= 263, "kidney_support_max")
    m.addConstr(21 * potassium + 23 * vitamin_a <= 199, "energy_stability_max")
    m.addConstr(24 * potassium + 24 * vitamin_a <= 128, "immune_support_max")
    m.addConstr(21 * potassium + 6 * vitamin_a <= 181, "muscle_growth_max")
    m.addConstr(3 * potassium + 17 * vitamin_a <= 207, "cognitive_performance_max")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Potassium: %g' % potassium.x)
        print('Vitamin A: %g' % vitamin_a.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
