
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_potassium")
x2 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_A")

# Set the objective function
m.setObjective(5*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(17*x1 + 5*x2 >= 49, "kidney_support_index_min")
m.addConstr(21*x1 + 23*x2 >= 120, "energy_stability_index_min")
m.addConstr(24*x1 + 24*x2 >= 95, "immune_support_index_min")
m.addConstr(21*x1 + 6*x2 >= 161, "muscle_growth_index_min")
m.addConstr(3*x1 + 17*x2 >= 86, "cognitive_performance_index_min")
m.addConstr(3*x1 - 9*x2 >= 0, "additional_constraint")
m.addConstr(17*x1 + 5*x2 <= 263, "kidney_support_index_max")
m.addConstr(21*x1 + 23*x2 <= 199, "energy_stability_index_max")
m.addConstr(24*x1 + 24*x2 <= 128, "immune_support_index_max")
m.addConstr(21*x1 + 6*x2 <= 181, "muscle_growth_index_max")
m.addConstr(3*x1 + 17*x2 <= 207, "cognitive_performance_index_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of potassium: {x1.x}")
    print(f"Milligrams of vitamin A: {x2.x}")
else:
    print("No optimal solution found")
