
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x1 = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="milligrams_of_potassium")
x2 = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="milligrams_of_vitamin_A")

# Objective function
m.setObjective(5 * x1 + 3 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(17 * x1 + 5 * x2 >= 49, name="kidney_support_index")
m.addConstr(21 * x1 + 23 * x2 >= 120, name="energy_stability_index")
m.addConstr(24 * x1 + 24 * x2 >= 95, name="immune_support_index")
m.addConstr(21 * x1 + 6 * x2 >= 161, name="muscle_growth_index")
m.addConstr(3 * x1 + 17 * x2 >= 86, name="cognitive_performance_index")
m.addConstr(3 * x1 - 9 * x2 >= 0, name="interaction_constraint")
m.addConstr(17 * x1 + 5 * x2 <= 263, name="kidney_support_index_upper_bound")
m.addConstr(21 * x1 + 23 * x2 <= 199, name="energy_stability_index_upper_bound")
m.addConstr(24 * x1 + 24 * x2 <= 128, name="immune_support_index_upper_bound")
m.addConstr(21 * x1 + 6 * x2 <= 181, name="muscle_growth_index_upper_bound")
m.addConstr(3 * x1 + 17 * x2 <= 207, name="cognitive_performance_index_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of potassium: {x1.varValue}")
    print(f"Milligrams of vitamin A: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
