
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Employee_Hours")

    # Create variables
    peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
    paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
    bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")


    # Set objective function
    model.setObjective(7.9 * peggy + 9.83 * paul + 7.21 * bobby, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(18 * peggy + 13 * paul >= 29, "c1")
    model.addConstr(20 * peggy + 13 * paul >= 59, "c2")
    model.addConstr(4 * peggy + 1 * bobby <= 177, "c3")
    model.addConstr(4 * peggy + 6 * paul <= 187, "c4")
    model.addConstr(6 * paul + 1 * bobby <= 167, "c5")
    model.addConstr(4 * peggy + 6 * paul + 1 * bobby <= 191, "c6")
    model.addConstr(18 * peggy + 13 * paul <= 107, "c7")
    model.addConstr(13 * paul + 21 * bobby <= 62, "c8")
    model.addConstr(18 * peggy + 13 * paul + 21 * bobby <= 62, "c9")
    model.addConstr(13 * paul + 7 * bobby <= 150, "c10")
    model.addConstr(20 * peggy + 13 * paul <= 208, "c11")
    model.addConstr(20 * peggy + 7 * bobby <= 206, "c12")
    model.addConstr(20 * peggy + 13 * paul + 7 * bobby <= 206, "c13")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Peggy: %g' % peggy.x)
        print('Paul: %g' % paul.x)
        print('Bobby: %g' % bobby.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
