
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Peggy
x1 = m.addVar(name="x1", lb=0)  # hours worked by Paul
x2 = m.addVar(name="x2", lb=0)  # hours worked by Bobby

# Define the objective function
m.setObjective(7.9*x0 + 9.83*x1 + 7.21*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(18*x0 + 13*x1 >= 29)
m.addConstr(20*x0 + 13*x1 >= 59)
m.addConstr(4*x0 + x2 <= 177)
m.addConstr(4*x0 + 6*x1 <= 187)
m.addConstr(6*x1 + x2 <= 167)
m.addConstr(4*x0 + 6*x1 + x2 <= 191)
m.addConstr(18*x0 + 13*x1 <= 107)
m.addConstr(13*x1 + 21*x2 <= 62)
m.addConstr(18*x0 + 13*x1 + 21*x2 <= 62)
m.addConstr(13*x1 + 7*x2 <= 150)
m.addConstr(20*x0 + 13*x1 <= 208)
m.addConstr(20*x0 + 7*x2 <= 206)
m.addConstr(20*x0 + 13*x1 + 7*x2 <= 206)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Peggy: ", x0.varValue)
    print("Hours worked by Paul: ", x1.varValue)
    print("Hours worked by Bobby: ", x2.varValue)
else:
    print("The model is infeasible")
