
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")


    # Set objective function
    m.setObjective(5.8 * x0 + 4.68 * x1 + 8.98 * x2 + 8.57 * x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(x1 + 4*x2 >= 15)
    m.addConstr(4*x2 + 5*x3 >= 7)
    m.addConstr(x0 + 4*x2 >= 6)
    m.addConstr(3*x1 + 5*x3 >= 5)
    m.addConstr(3*x1 + 4*x2 + 5*x3 >= 9)
    m.addConstr(x0 + 3*x1 + 4*x2 >= 9)
    m.addConstr(x0 + 4*x2 + 5*x3 >= 9)
    m.addConstr(3*x1 + 4*x2 + 5*x3 >= 16)
    m.addConstr(x0 + 3*x1 + 4*x2 >= 16)
    m.addConstr(x0 + 4*x2 + 5*x3 >= 16)
    m.addConstr(3*x1 + 4*x2 + 5*x3 >= 16)
    m.addConstr(x0 + 3*x1 + 4*x2 >= 16)
    m.addConstr(x0 + 4*x2 + 5*x3 >= 16)
    m.addConstr(x0 + 3*x1 + 4*x2 + 5*x3 >= 16)
    m.addConstr(3*x0 + 5*x1 >= 12)
    m.addConstr(3*x0 + 4*x3 >= 19)
    m.addConstr(5*x1 + 3*x2 >= 23)
    m.addConstr(3*x0 + 3*x2 >= 21)
    m.addConstr(5*x1 + 3*x2 + 4*x3 >= 25)
    m.addConstr(3*x0 + 5*x1 + 4*x3 >= 25)
    m.addConstr(3*x0 + 5*x1 + 3*x2 >= 25)
    m.addConstr(5*x1 + 3*x2 + 4*x3 >= 15)
    m.addConstr(3*x0 + 5*x1 + 4*x3 >= 15)
    m.addConstr(3*x0 + 5*x1 + 3*x2 >= 15)
    m.addConstr(5*x1 + 3*x2 + 4*x3 >= 16)
    m.addConstr(3*x0 + 5*x1 + 4*x3 >= 16)
    m.addConstr(3*x0 + 5*x1 + 3*x2 >= 16)
    m.addConstr(3*x0 + 5*x1 + 3*x2 + 4*x3 >= 16)
    m.addConstr(2*x0 - 9*x2 >= 0)
    m.addConstr(3*x1 + 5*x3 <= 51)
    m.addConstr(3*x1 + 4*x2 <= 29)
    m.addConstr(x0 + 5*x3 <= 21)
    m.addConstr(4*x2 + 5*x3 <= 67)
    m.addConstr(3*x0 + 3*x2 <= 53)
    m.addConstr(3*x0 + 4*x3 <= 35)
    m.addConstr(3*x0 + 5*x1 <= 62)
    m.addConstr(3*x2 + 4*x3 <= 89)
    m.addConstr(5*x1 + 3*x2 <= 84)
    m.addConstr(3*x0 + 3*x2 + 4*x3 <= 46)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
