
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="milligrams of vitamin B6")
    x1 = model.addVar(lb=0, name="grams of fat")
    x2 = model.addVar(lb=0, name="milligrams of calcium")
    x3 = model.addVar(lb=0, name="milligrams of vitamin B5")

    # Objective function
    model.setObjective(5.8*x0 + 4.68*x1 + 8.98*x2 + 8.57*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x0 <= 70, name="c1")
    model.addConstr(3*x0 <= 106, name="c2")
    model.addConstr(3*x1 <= 70, name="c3")
    model.addConstr(5*x1 <= 106, name="c4")
    model.addConstr(4*x2 <= 70, name="c5")
    model.addConstr(3*x2 <= 106, name="c6")
    model.addConstr(5*x3 <= 70, name="c7")
    model.addConstr(4*x3 <= 106, name="c8")
    model.addConstr(3*x1 + 4*x2 >= 15, name="c9")
    model.addConstr(4*x2 + 5*x3 >= 7, name="c10")
    model.addConstr(x0 + 4*x2 >= 6, name="c11")
    model.addConstr(3*x1 + 5*x3 >= 5, name="c12")
    model.addConstr(3*x1 + 4*x2 + 5*x3 >= 9, name="c13")
    model.addConstr(x0 + 3*x1 + 4*x2 >= 9, name="c14")
    model.addConstr(x0 + 4*x2 + 5*x3 >= 9, name="c15")
    model.addConstr(3*x1 + 4*x2 + 5*x3 >= 16, name="c16")
    model.addConstr(x0 + 3*x1 + 4*x2 >= 16, name="c17")
    model.addConstr(x0 + 4*x2 + 5*x3 >= 16, name="c18")
    model.addConstr(3*x1 + 4*x2 + 5*x3 >= 16, name="c19")
    model.addConstr(x0 + 3*x1 + 4*x2 >= 16, name="c20")
    model.addConstr(x0 + 4*x2 + 5*x3 >= 16, name="c21")
    model.addConstr(x0 + 3*x1 + 4*x2 + 5*x3 >= 16, name="c22")
    model.addConstr(3*x0 + 5*x1 >= 12, name="c23")
    model.addConstr(3*x0 + 4*x3 >= 19, name="c24")
    model.addConstr(5*x1 + 3*x2 >= 23, name="c25")
    model.addConstr(3*x0 + 3*x2 >= 21, name="c26")
    model.addConstr(5*x1 + 3*x2 + 4*x3 >= 25, name="c27")
    model.addConstr(3*x0 + 5*x1 + 4*x3 >= 25, name="c28")
    model.addConstr(3*x0 + 5*x1 + 3*x2 >= 25, name="c29")
    model.addConstr(5*x1 + 3*x2 + 4*x3 >= 15, name="c30")
    model.addConstr(3*x0 + 5*x1 + 4*x3 >= 15, name="c31")
    model.addConstr(3*x0 + 5*x1 + 3*x2 >= 15, name="c32")
    model.addConstr(5*x1 + 3*x2 + 4*x3 >= 16, name="c33")
    model.addConstr(3*x0 + 5*x1 + 4*x3 >= 16, name="c34")
    model.addConstr(3*x0 + 5*x1 + 3*x2 >= 16, name="c35")
    model.addConstr(3*x0 + 5*x1 + 3*x2 + 4*x3 >= 16, name="c36")
    model.addConstr(2*x0 - 9*x2 >= 0, name="c37")
    model.addConstr(3*x1 + 5*x3 <= 51, name="c38")
    model.addConstr(3*x1 + 4*x2 <= 29, name="c39")
    model.addConstr(x0 + 5*x3 <= 21, name="c40")
    model.addConstr(4*x2 + 5*x3 <= 67, name="c41")
    model.addConstr(3*x0 + 3*x2 <= 53, name="c42")
    model.addConstr(3*x0 + 4*x3 <= 35, name="c43")
    model.addConstr(3*x0 + 5*x1 <= 62, name="c44")
    model.addConstr(4*x2 + 5*x3 <= 89, name="c45")
    model.addConstr(5*x1 + 3*x2 <= 84, name="c46")
    model.addConstr(3*x0 + 3*x2 + 5*x3 <= 46, name="c47")

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("milligrams of vitamin B6: ", x0.varValue)
        print("grams of fat: ", x1.varValue)
        print("milligrams of calcium: ", x2.varValue)
        print("milligrams of vitamin B5: ", x3.varValue)
        print("Objective: ", model.objVal)
    else:
        print("No optimal solution found.")

optimize_problem()
